# -*- coding: utf-8 -*-
from ladon.ladonizer import ladonize
from ladon.types.ladontype import LadonType
from mysite.utils import get_option
import json
from django.db import models
from mysite import utils
import sys

from comm.att.struct.sync_action import *
RET_INFO={}
class DeptService(object):
    
    u"""
    【部门操作】包含更新或新增、撤销部门等操作
    """
    @ladonize(str,rtype=str)
    def delDept(self,code):
        """
        撤销部门
        
        @param code:参数一  部门编号
        @rtype: 返回信息 
            0    成功 
            -98    部门编号不存在
            -136    该部门还有下级子部门，不能撤消
            -137    该部门还有职位，不能撤消 
            -138    该部门还有人员，不能撤消
            -139    根部门不能撤消
        """
        from mysite.personnel.models.model_dept import Department
        from base.sync_audit_api import del_dapartment
        from base.cached_model import STATUS_INVALID
        import datetime                     
        RET_INFO['operation']='deleteDept'
        try:
            d=Department.objects.get(code=u'%s'%code)
        except:
            RET_INFO['ret']='-98'
            return json.dumps(RET_INFO)
        if d.id== 1:
            RET_INFO['ret']='-139'
            return json.dumps(RET_INFO)
        if len(d.children()) > 0:
            RET_INFO['ret']='-136'
            return json.dumps(RET_INFO)
        emps=d.employee_set.all()
        if len(emps)>0:
            RET_INFO['ret']='-138'
            return json.dumps(RET_INFO)
        postions=d.position_set.all()
        if len(postions)>0:
            RET_INFO['ret']='-137'
            return json.dumps(RET_INFO)
        d.invalidate = datetime.datetime.now().strftime("%Y-%m-%d")
        d.status = STATUS_INVALID
        del_dapartment(d)
        super(Department, d).save()
        RET_INFO['ret']='0'
        RET_INFO['id']=d.id
        return json.dumps(RET_INFO)
                     
        
    @ladonize(str,str,str,rtype=str)
    def setDept(self,code,name,parentCode):
        """
        新增或编辑部门
 
        @param code:参数一   部门编号(必填)
        @param name:参数二  部门名称 
        @param parentCode:参数三  父部门编号
        @rtype: 返回信息,
             0    成功
            -140    部门编号不能为空
            -141    不能设置部门的上级部门为其自身或其子部门
            -142    部门编号已经存在
            -143    默认根部门不能有上级部门
               """
        from mysite.personnel.models.model_dept import Department
        from base.cached_model import STATUS_INVALID
        RET_INFO['operation']='setDept'
        if not code:
            RET_INFO['ret']='-140'
            return json.dumps(RET_INFO)
        if u"%s"%code == u"%s"%parentCode:
            RET_INFO['ret']='-141'
            return json.dumps(RET_INFO)
        d = None
        try:#修改
            d = Department.all_objects.get(code=u"%s"%code)
            if d.status == STATUS_INVALID:
               RET_INFO['ret']='-142'
               return json.dumps(RET_INFO)
            if d.id == 1 and parentCode:
               RET_INFO['ret']='-143'
               return json.dumps(RET_INFO) 
            if parentCode:
                try:#父部门处理
                    p_d = Department.objects.get(code=u"%s"%parentCode)
                except:
                    p_d = Department()
                    p_d.code = u"%s"%parentCode
                    p_d.name = u"%s"%parentCode
                    p_d.save()
                d.parent = p_d
                RET_INFO['p_id']=p_d.id
            d.name = u"%s"%name
            d.save()
            RET_INFO['ret']='0'
            RET_INFO['id']=d.id
            return json.dumps(RET_INFO)
        except:#新增
            d = Department()
            if parentCode:
                try:#父部门处理
                    p_d = Department.objects.get(code=u"%s"%parentCode)
                except:
                    p_d = Department()
                    p_d.code = u"%s"%parentCode
                    p_d.name = u"%s"%parentCode
                    p_d.save()
                d.parent = p_d
                RET_INFO['p_id']=p_d.id
            d.code = u"%s"%code
            d.name = u"%s"%(name or code)
            d.save()
            RET_INFO['ret']='0'
            RET_INFO['id']=d.id
            return json.dumps(RET_INFO)
